/*
 * Decompiled with CFR 0.152.
 */
package frc.util;

import java.awt.Toolkit;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;

public class DeadlockChecker
implements Runnable {
    public static String CHECK_THREAD_NAME = "Contention Monitor";
    public static long CHECK_INTERVAL_MS = 4000L;
    private static DeadlockChecker activeChecker;
    private final ThreadMXBean thMgr = ManagementFactory.getThreadMXBean();
    private Thread checkThread;
    private long checkInterval;

    public static final synchronized boolean isActive() {
        return activeChecker != null && activeChecker.isActiveAndRunning();
    }

    public static final synchronized void activate() {
        DeadlockChecker.activate(null, 0L);
    }

    public static final synchronized void activate(String string) {
        DeadlockChecker.activate(string, 0L);
    }

    public static final synchronized void activate(String string, long l) {
        if (!DeadlockChecker.isActive()) {
            activeChecker = new DeadlockChecker();
            activeChecker.launch(string, l);
        }
    }

    private DeadlockChecker() {
        if (this.thMgr.isThreadContentionMonitoringSupported()) {
            this.thMgr.setThreadContentionMonitoringEnabled(true);
        }
        System.out.println("Thread Contention Monitoring : " + (this.thMgr.isThreadContentionMonitoringEnabled() ? "enabled" : "n/a"));
    }

    private synchronized void launch(String string, long l) {
        if (this.thMgr.isThreadContentionMonitoringEnabled()) {
            this.checkInterval = l <= 0L ? CHECK_INTERVAL_MS : l;
            this.checkThread = new Thread((Runnable)this, string == null ? CHECK_THREAD_NAME : string);
            this.checkThread.setPriority(1);
            this.checkThread.start();
        }
    }

    private synchronized boolean isActiveAndRunning() {
        return this.checkThread != null;
    }

    public synchronized void run() {
        while (true) {
            try {
                do {
                    Thread.sleep(this.checkInterval);
                } while (!this.checkForDeadlock());
                int n = 0;
                while (n < 3) {
                    Toolkit.getDefaultToolkit().beep();
                    Thread.sleep(100L);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            break;
        }
        this.checkThread = null;
    }

    private boolean checkForDeadlock() {
        long[] lArray = this.thMgr.findMonitorDeadlockedThreads();
        if (lArray == null) {
            return false;
        }
        System.out.flush();
        ThreadInfo[] threadInfoArray = this.thMgr.getThreadInfo(lArray, Integer.MAX_VALUE);
        System.err.println(" ");
        System.err.println(" ##################################");
        System.err.println(" ##   Thread Deadlock Detected   ##");
        System.err.println(" ##################################");
        System.err.println(" ");
        int n = 0;
        while (n < threadInfoArray.length) {
            ThreadInfo threadInfo = threadInfoArray[n];
            StackTraceElement[] stackTraceElementArray = threadInfo.getStackTrace();
            String string = DeadlockChecker.getLockString(threadInfo.getLockName());
            StringBuilder stringBuilder = new StringBuilder(80);
            if (n > 0) {
                System.err.println("___________________________________________________________________________________");
            }
            stringBuilder.append("Thread #").append(threadInfo.getThreadId()).append(" [").append(threadInfo.getThreadName()).append("] - ").append((Object)threadInfo.getThreadState()).append(" on [").append(string).append("]");
            System.err.println(stringBuilder.toString());
            stringBuilder = new StringBuilder(80);
            stringBuilder.append("> Lock [").append(string).append("] is owned by #").append(threadInfo.getLockOwnerId()).append(" (").append(threadInfo.getLockOwnerName()).append(')');
            System.err.println(stringBuilder.toString());
            int n2 = DeadlockChecker.getStackStopIndex(stackTraceElementArray);
            int n3 = 0;
            while (n3 < stackTraceElementArray.length) {
                if (n2 > 0 && n3 > n2) {
                    System.err.println("  [ ... ]");
                    break;
                }
                System.err.println("  | " + stackTraceElementArray[n3]);
                ++n3;
            }
            ++n;
        }
        System.err.flush();
        return true;
    }

    private static String getLockString(String string) {
        if (string == null) {
            return "null";
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(64)) >= 0) {
            string = String.valueOf(string.substring(0, n)) + ":" + string.substring(n + 1);
        }
        return string;
    }

    private static int getStackStopIndex(StackTraceElement[] stackTraceElementArray) {
        if (stackTraceElementArray != null) {
            int n = stackTraceElementArray.length;
            while (n-- > 0) {
                String string = stackTraceElementArray[n].getClassName();
                if (string.startsWith("javax.") || string.startsWith("java.")) continue;
                return n == stackTraceElementArray.length - 1 ? -1 : n + 1;
            }
        }
        return -1;
    }
}

